/*
 * Decompiled with CFR 0.152.
 */
package acm.program;

import acm.io.IOConsole;
import acm.program.MacCheckboxMenuItem;
import acm.program.MacMenuItem;
import acm.program.Program;
import acm.program.ProgramMenuListener;
import acm.util.Platform;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class ProgramMenuBar
extends JMenuBar {
    private Program myProgram;
    private ProgramMenuListener listener;
    private IOConsole activeConsole;

    public ProgramMenuBar(Program program) {
        this.myProgram = program;
        this.listener = new ProgramMenuListener(program);
        this.init();
    }

    public void setConsole(IOConsole iOConsole) {
        this.activeConsole = iOConsole;
    }

    public IOConsole getConsole() {
        return this.activeConsole;
    }

    public void update() {
        int n = this.getMenuCount();
        int n2 = 0;
        while (n2 < n) {
            this.updateMenuItem(this.getMenu(n2));
            ++n2;
        }
    }

    protected void init() {
        this.add(this.createFileMenu());
        this.add(this.createEditMenu());
    }

    protected JMenu createFileMenu() {
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        this.addSaveItems(jMenu);
        jMenu.addSeparator();
        this.addPrintItems(jMenu);
        jMenu.addSeparator();
        this.addQuitItem(jMenu);
        return jMenu;
    }

    protected JMenu createEditMenu() {
        JMenu jMenu = new JMenu("Edit");
        jMenu.setMnemonic(69);
        this.addEditItems(jMenu);
        return jMenu;
    }

    protected void addQuitItem(JMenu jMenu) {
        if (Platform.isMac()) {
            JMenuItem jMenuItem = this.createMenuItem("Quit", 81, 0);
            jMenuItem.setEnabled(true);
            jMenu.add(jMenuItem);
        } else {
            JMenuItem jMenuItem = this.createMenuItem("Exit", 0, 88);
            jMenuItem.setActionCommand("Quit");
            jMenuItem.setEnabled(true);
            jMenu.add(jMenuItem);
        }
    }

    protected void addEditItems(JMenu jMenu) {
        if (Platform.isMac()) {
            jMenu.add(this.createMenuItem("Cut", 88, 0));
            jMenu.add(this.createMenuItem("Copy", 67, 0));
            jMenu.add(this.createMenuItem("Paste", 86, 0));
            jMenu.add(this.createMenuItem("Select All", 65, 0));
        } else {
            JMenuItem jMenuItem = this.createMenuItem("Cut (x)", 88, 0);
            jMenuItem.setActionCommand("Cut");
            jMenu.add(jMenuItem);
            jMenuItem = this.createMenuItem("Copy (c)", 67, 0);
            jMenuItem.setActionCommand("Copy");
            jMenu.add(jMenuItem);
            jMenuItem = this.createMenuItem("Paste (v)", 86, 0);
            jMenuItem.setActionCommand("Paste");
            jMenu.add(jMenuItem);
            jMenu.add(this.createMenuItem("Select All", 65, 0));
        }
    }

    protected void addSaveItems(JMenu jMenu) {
        jMenu.add(this.createMenuItem("Save", 83, 0));
        jMenu.add(this.createMenuItem("Save As...", 0, 0));
    }

    protected void addPrintItems(JMenu jMenu) {
        jMenu.add(this.createMenuItem("Print", 80, 0));
        jMenu.add(this.createMenuItem("Print Console", 0, 0));
        jMenu.add(this.createMenuItem("Script...", 0, 0));
    }

    protected Menu createProgramMenu() {
        Menu menu = new Menu("Program");
        int n = this.getMenuCount();
        int n2 = 0;
        while (n2 < n) {
            this.addProgramMenuItems(menu, this.getMenu(n2));
            ++n2;
        }
        return menu;
    }

    protected MenuBar createMacMenuBar() {
        MenuBar menuBar = new MenuBar();
        int n = this.getMenuCount();
        int n2 = 0;
        while (n2 < n) {
            menuBar.add(this.createMacMenu(this.getMenu(n2)));
            ++n2;
        }
        return menuBar;
    }

    private JMenuItem createMenuItem(String string, int n, int n2) {
        JMenuItem jMenuItem = n2 == 0 ? new JMenuItem(string) : new JMenuItem(string, n2);
        jMenuItem.addActionListener(this.listener);
        if (n != 0) {
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke((int)((char)n), 2));
        }
        jMenuItem.setEnabled(false);
        if (string.endsWith("...")) {
            jMenuItem.setActionCommand(string.substring(0, string.length() - 3));
        }
        return jMenuItem;
    }

    private Menu createMacMenu(JMenu jMenu) {
        Menu menu = new Menu(jMenu.getText());
        int n = jMenu.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            menu.add(this.createMacMenuItem(jMenu.getItem(n2)));
            ++n2;
        }
        return menu;
    }

    private MenuItem createMacMenuItem(JMenuItem jMenuItem) {
        if (jMenuItem == null) {
            return new MenuItem("-");
        }
        if (jMenuItem instanceof JMenu) {
            return this.createMacMenu((JMenu)jMenuItem);
        }
        if (jMenuItem instanceof JCheckBoxMenuItem) {
            return new MacCheckboxMenuItem((JCheckBoxMenuItem)jMenuItem);
        }
        return new MacMenuItem(jMenuItem);
    }

    private void addProgramMenuItems(Menu menu, JMenuItem jMenuItem) {
        if (jMenuItem == null) {
            menu.addSeparator();
        } else if (jMenuItem instanceof JMenu) {
            JMenu jMenu = (JMenu)jMenuItem;
            int n = jMenu.getItemCount();
            int n2 = 0;
            while (n2 < n) {
                this.addProgramMenuItems(menu, jMenu.getItem(n2));
                ++n2;
            }
        } else if (jMenuItem instanceof JCheckBoxMenuItem) {
            menu.add(new MacCheckboxMenuItem((JCheckBoxMenuItem)jMenuItem));
        } else if (!jMenuItem.getActionCommand().equals("Quit")) {
            menu.add(new MacMenuItem(jMenuItem));
        }
    }

    protected void updateMenuItem(JMenuItem jMenuItem) {
        if (jMenuItem instanceof JMenu) {
            JMenu jMenu = (JMenu)jMenuItem;
            int n = jMenu.getItemCount();
            int n2 = 0;
            while (n2 < n) {
                JMenuItem jMenuItem2 = jMenu.getItem(n2);
                if (jMenuItem2 != null) {
                    this.updateMenuItem(jMenuItem2);
                }
                ++n2;
            }
        } else {
            this.myProgram.updateMenuItem(jMenuItem);
        }
    }
}

